/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc.bcast;

import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.fcs.impl.udp.NotificationQueue;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class DatagramPortOwner {
    protected static final String MULTICAST_ADDRESS = "225.4.5.6";
    private static final String TRACE_MASKD = "XFCSDPOD";
    private static final String TRACE_MASKF = "XFCSDPOF";
    private static final String TRACE_MASKT = "XFCSDPOT";
    private static DatagramPortOwner _singleton;
    private DatagramSocket outSocket;
    private DatagramSocket inSocket;
    private static boolean allowBroadcastOverPublicNetworks;
    private static NotificationQueue datagramQueue;
    private DatagramSocket[] outSockets;
    private static SocketListener[] socketListeners;
    private boolean useMultipleSockets = false;
    private boolean useMulticast = false;
    private static MachineId machineId;
    private boolean firstTry = true;

    public static synchronized DatagramPortOwner getDatagramPortOwner() {
        if (_singleton == null) {
            _singleton = new DatagramPortOwner();
        }
        return _singleton;
    }

    public void send(DatagramPacket packet) {
        block9: {
            block8: {
                if (!this.useMultipleSockets) break block8;
                if (this.outSockets == null) {
                    this.buildSocket();
                }
                if (this.outSockets == null) break block9;
                int i = 0;
                while (i < this.outSockets.length) {
                    if (this.outSockets[i] != null) {
                        try {
                            this.outSockets[i].send(packet);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                break block9;
            }
            if (this.outSocket == null) {
                this.buildSocket();
            }
            if (this.outSocket == null) break block9;
            try {
                this.outSocket.send(packet);
            }
            catch (IOException ioe) {}
        }
    }

    public DatagramPacket receive() {
        DatagramPacket inPacket;
        block8: {
            if (this.useMultipleSockets) {
                Object inPacket2 = null;
                if (socketListeners == null) {
                    this.buildSocket();
                }
                if (socketListeners != null) {
                    DatagramPacket fcsDatagram = (DatagramPacket)datagramQueue.readItem();
                    return fcsDatagram;
                }
                return null;
            }
            inPacket = null;
            if (this.inSocket == null) {
                this.buildSocket();
            }
            if (this.inSocket == null) break block8;
            byte[] buffer = new byte[504];
            inPacket = new DatagramPacket(buffer, buffer.length);
            try {
                this.inSocket.receive(inPacket);
                FcsDatagram datagram = new FcsDatagram(inPacket);
            }
            catch (FcsException fcse) {
                inPacket = null;
            }
            catch (IOException ioe) {
                inPacket = null;
            }
            catch (Exception e) {
                inPacket = null;
            }
        }
        return inPacket;
    }

    public boolean socketBuildError() {
        if (this.useMultipleSockets) {
            return socketListeners == null && !this.firstTry;
        }
        return this.inSocket == null && !this.firstTry;
    }

    private DatagramPortOwner() {
        this.buildSocket();
        machineId = FcsServer.getFcsServer().getLocalMachineId();
        datagramQueue = new NotificationQueue();
        allowBroadcastOverPublicNetworks = FcsServer.getFcsServer().getConfigManager().isUsePublicBroadcast();
        this.useMulticast = FcsServer.getFcsServer().getConfigManager().isUseMulticast();
    }

    private synchronized void buildSocket() {
        block34: {
            if (!this.firstTry) {
                return;
            }
            this.firstTry = false;
            if (this.useMultipleSockets) {
                try {
                    if (this.outSockets == null && machineId != null) {
                        int count = 0;
                        int i = 0;
                        while (i < machineId.getNicAddresses().length) {
                            if (!machineId.getPublicNetworkIndicators()[i] || allowBroadcastOverPublicNetworks) {
                                ++count;
                            }
                            ++i;
                        }
                        this.outSockets = new DatagramSocket[count];
                        count = 0;
                        int i2 = 0;
                        while (i2 < machineId.getNicAddresses().length) {
                            if (!machineId.getPublicNetworkIndicators()[i2] || allowBroadcastOverPublicNetworks) {
                                if (this.useMulticast) {
                                    this.outSockets[count] = new MulticastSocket();
                                    ((MulticastSocket)this.outSockets[count]).setTimeToLive(5);
                                    ((MulticastSocket)this.outSockets[count]).joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                                    ((MulticastSocket)this.outSockets[count]).setInterface(machineId.getNicAddresses()[i2]);
                                } else {
                                    this.outSockets[count] = new DatagramSocket();
                                    Trace.trace(TRACE_MASKF, "created new outSocket");
                                }
                                ++count;
                            }
                            ++i2;
                        }
                    }
                }
                catch (SocketException se) {
                    Trace.trace(TRACE_MASKF, se);
                    this.outSockets = null;
                }
                catch (IOException ioe) {
                    Trace.trace(TRACE_MASKF, ioe);
                    this.outSockets = null;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                    this.outSockets = null;
                }
                try {
                    if (socketListeners != null) {
                        int i = 0;
                        while (i < socketListeners.length) {
                            socketListeners[i].closeSocket();
                            ++i;
                        }
                    }
                    if (machineId == null) break block34;
                    socketListeners = new SocketListener[machineId.getNicAddresses().length];
                    int i = 0;
                    while (i < socketListeners.length) {
                        if (this.useMulticast) {
                            MulticastSocket tmpSocket = new MulticastSocket(9900);
                            tmpSocket.joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                            tmpSocket.setInterface(machineId.getNicAddresses()[i]);
                            DatagramPortOwner.socketListeners[i] = new SocketListener(tmpSocket, datagramQueue);
                        } else {
                            DatagramPortOwner.socketListeners[i] = new SocketListener(new DatagramSocket(9900), datagramQueue);
                        }
                        socketListeners[i].start();
                        ++i;
                    }
                }
                catch (SocketException se) {
                    Trace.trace(TRACE_MASKF, se);
                    socketListeners = null;
                }
                catch (IOException ioe) {
                    Trace.trace(TRACE_MASKF, ioe);
                    socketListeners = null;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                    socketListeners = null;
                }
            } else {
                try {
                    if (this.outSocket == null) {
                        if (this.useMulticast) {
                            this.outSocket = new MulticastSocket();
                            ((MulticastSocket)this.outSocket).setTimeToLive(5);
                            ((MulticastSocket)this.outSocket).joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                            ((MulticastSocket)this.outSocket).setInterface(InetAddress.getLocalHost());
                        } else {
                            this.outSocket = new DatagramSocket();
                        }
                    }
                }
                catch (SocketException se) {
                    this.outSocket = null;
                }
                catch (IOException ioe) {
                    this.outSocket = null;
                }
                try {
                    if (this.inSocket != null) {
                        this.inSocket.close();
                    }
                    if (this.useMulticast) {
                        this.inSocket = new MulticastSocket(9900);
                        ((MulticastSocket)this.inSocket).joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                        ((MulticastSocket)this.inSocket).setInterface(InetAddress.getLocalHost());
                        break block34;
                    }
                    this.inSocket = new DatagramSocket(9900);
                }
                catch (SocketException se) {
                    this.inSocket = null;
                }
                catch (IOException ioe) {
                    this.inSocket = null;
                }
            }
        }
    }

    public void setUseMulticast(boolean value) {
        if (this.useMulticast != value) {
            this.useMulticast = value;
            this.closeSocket();
            this.buildSocket();
        }
    }

    public void closeSocket() {
        block14: {
            block13: {
                int i;
                this.firstTry = true;
                if (!this.useMultipleSockets) break block13;
                if (this.outSockets != null) {
                    i = 0;
                    while (i < this.outSockets.length) {
                        try {
                            this.outSockets[i].close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    this.outSockets = null;
                }
                if (socketListeners == null) break block14;
                i = 0;
                while (i < socketListeners.length) {
                    if (socketListeners[i] != null) {
                        try {
                            socketListeners[i].closeSocket();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                socketListeners = null;
                break block14;
            }
            if (this.outSocket != null) {
                try {
                    this.outSocket.close();
                    this.outSocket = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.inSocket == null) break block14;
            try {
                this.inSocket.close();
                this.inSocket = null;
            }
            catch (Exception e) {}
        }
    }

    public void restart() {
        if (this.useMultipleSockets) {
            if (this.outSockets == null || socketListeners == null) {
                this.buildSocket();
            }
        } else if (this.outSocket == null || this.inSocket == null) {
            this.buildSocket();
        }
    }

    public void networkSettingsChanged() {
        this.closeSocket();
        this.buildSocket();
        MachineId tmp = null;
        try {
            tmp = FcsServer.getFcsServer().getLocalMachineId();
            if (tmp != null) {
                machineId = tmp;
            }
        }
        catch (Exception e) {}
    }

    public void setAllowBroadcastOverPublicNetworks(boolean newVal) {
        Trace.trace(TRACE_MASKF, "setAllowBroadcastOverPublicNetworks(" + newVal + ")");
        if (newVal != allowBroadcastOverPublicNetworks) {
            allowBroadcastOverPublicNetworks = newVal;
            this.closeSocket();
            this.buildSocket();
        }
    }

    class SocketListener
    extends Thread {
        private static final String TRACE_MASKD = "XFCSDSLD";
        private static final String TRACE_MASKF = "XFCSDSLF";
        private static final String TRACE_MASKT = "XFCSDSLT";
        private DatagramSocket socket;
        private NotificationQueue datagramQueue;

        public SocketListener(DatagramSocket socket, NotificationQueue datagramQueue) {
            Trace.trace(TRACE_MASKF, "<> SocketListener");
            this.socket = socket;
            this.datagramQueue = datagramQueue;
        }

        public void closeSocket() {
            Trace.trace(TRACE_MASKF, "<> closeSocket()");
            try {
                this.socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.socket = null;
            }
            catch (Exception e) {}
        }

        public void run() {
            try {
                this.setName("FCS Datagram socket listener on: " + this.socket.toString());
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
            }
            while (this.socket != null) {
                byte[] buffer = new byte[504];
                DatagramPacket inPacket = new DatagramPacket(buffer, buffer.length);
                try {
                    this.socket.receive(inPacket);
                    FcsDatagram datagram = new FcsDatagram(inPacket);
                    this.datagramQueue.addItem(inPacket);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
    }
}

